
markup.push({

// --------------------------------------------------------
// templates for 4 base block types
// MARK: block templates

BlockTemplate:
{
	nsClass: "GEBlockView",
	gxFrameRect: "0,0,120,120",	// frame used by settings view on block face, not the block itself
	gxShadow: "{0, 0, 0, 0.2}, {0, 0}, 5",
	gxSelectionColor: "SelectionColor2",
	gxTitlePainter: "BlockTitleFore",
	gxBlockTopPainter: "BlockTopBack",
	gxBlockBottomPainter: "BlockBottomBack",
    gxSelectionPainter: "BlockSelection",
	gxLibraryBlockPainter: "LibraryBlockPainter",
	gxLibraryIconPainter: "LibraryIconPainter",
	gxLibraryTitlePainter: "LabelFore.left.centery.size125.foreColor1.useMarkup.wrap",
	gxSocketView: "SocketView",
},

	
// -------------------------------------------------
// MARK: generic block types

OutputTemplate: {
	"+": "BlockTemplate",
	outputBlock: true
},

SourceTemplate: {
	"+": "BlockTemplate",
},

	
// -------------------------------------------------
// MARK: block fore painter

BlockTitleFore:
{
	"+": "LabelFore.top.foreColorTheme1.mediumWeight.size12",
	gxEdgeInsets: "4, 4, 4, 87",
	noTitle: {
		gxEdgeInsets: "999, 999, 999, 999"
	},
	tallTitle: {
		gxLineBreakMode: 0,	// word wrap
		gxEdgeInsets: "4, 3, 4, 71"
	},
	verticalTitle: {
		// insets and line height multiple allow 7 vertical chars
		// in block title - neatly clipping only due to fit
		gxEdgeInsets: "87, 7, 4, 7",
		gxVAlign: 0.5,
		gxLineHeightMultiple: 0.875,
	}
},

	
// -------------------------------------------------
// MARK: block back painters

BlockTopBack:
{
	nsClass: "GXPainter",
	gxEdgeInsets: "0, 0, 0, 83",
	gxCornerRadii: "13, 13, 0, 0",
	gxFillColor: "ColorTheme2",
	tallTitle: {
		gxEdgeInsets: "0, 0, 0, 69"
	},
	verticalTitle: {
		gxEdgeInsets: "83, 0, 0, 0",
		gxCornerRadii: "0, 13, 13, 0",
	},
	error: {
		gxFillColor: errorColor(77),
	},
	library: {
		// smaller sized library block
		gxEdgeInsets: "0, 0, 0, 26",
		gxCornerRadii: "4, 4, 0, 0"
	}
},

BlockBottomBack:
{
	nsClass: "GXPainter",
	gxEdgeInsets: "0, 22, 0, 0",
	gxCornerRadii: "0, 0, 13, 13",
	gxFillColor: "ColorTheme1",
	verticalTitle: {
		gxCornerRadii: "13, 13, 13, 13",
		gxEdgeInsets: "0, 0, 0, 0",
	},
	error: {
		gxFillColor: errorColor(98),
	},
	library: {
		// smaller sized library block
		gxEdgeInsets: "0, 6, 0, 0",
		gxCornerRadii: "0, 0, 4, 4"
	}
},

BlockSelection:
{
    nsClass: "GXPainter",
    selected: {
        gxEdgeInsets: "-4, -4, -4, -4",
        gxCornerRadius: 16.5,
        gxFillColor: "SelectionColor2.noBlockDisabled",
        error: {
			gxFillColor: errorColor(100, 45),
        },
    }
},

	
// -------------------------------------------------
// MARK: library block view painters

LibraryBlockPainter:
{
	nsClass: "GXPainter",
	gxEdgeInsets: "9, 6, 9, 6",
	gxCornerRadius: 6,
	gxFillColor: "ColorTheme1",
},

LibraryIconPainter:
{
	nsClass: "GXImagePainter",
	gxAlignment: "0.5, 0.5",
},

	
// -------------------------------------------------
// MARK: block buttons

BlockButton: {
	"+": "ButtonView",
	gxBackPainter: "BlockButtonBack",
	gxForePainter: "BlockButtonFore"
},

BlockButtonBack: {
	nsClass: "GXPainter",
	gxCornerRadius: 7,
	gxFillColor: "ColorTheme2",

	on: {
		gxFillColor: "ForeColorTheme1",
	},
	error: {
		gxFillColor: errorColor(60),
	},
	leftSegment:	{ gxCornerRadii: "8, 0, 0, 8" },
	middleSegment:	{ gxCornerRadius: 0 },
	rightSegment:	{ gxCornerRadii: "0, 8, 8, 0" }
},

BlockButtonFore: {
	"+": "ButtonFore.size10",
	gxVAlign: 0.6,
	gxFontColor: "ForeColorTheme1",
	on:	{
		gxFontColor: "ColorTheme2",
	},
},

// -------------------------------------------------
// MARK: block popup menu

BlockPopup: {
	"+": "PopupMenuView",
	gxFrameRect: "16,85,88,18",
	gxBackPainter: "BlockButtonBack",
	gxForePainter: "BlockPopupFore",
	gxExtraPainter: "BlockPopupArrows"
},
			
BlockPopupFore: {
	"+": "BlockButtonFore",
	gxHAlign: 0.5,
	gxEdgeInsets: "7, 0, 15, 0",
},

BlockPopupArrows: {
	"+": "PopupArrows",
	gxTintColor: "ForeColorTheme1",
},


})
